#!/bin/bash

set -e
PWD="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

ccmbVersion1=$1
ccmbVersion2=$2
installationsCount=$3
updatePath=/opt/LanTEK/update/
candidatePath=/opt/LanTEK/update/CCMB/
ccmb1Path=$updatePath/$ccmbVersion1
ccmb2Path=$updatePath/$ccmbVersion2

exampleUsage="\nInstall '3.5.6-9' and '3.8.2-1' 99 times (so 99*2 installations in total)\ntest-multiple-installations.sh 3.5.6-9 3.8.2-1 99"

if [[ -z $ccmbVersion1 || -z $ccmbVersion2 ]]
then
    echo -e "You have to provide ccmbVersion1 version and ccmbVersion2 version. Example usage:$exampleUsage"
    exit 1
fi

if [[ -z $installationsCount ]]
then
    echo -e "Please provide installationsCount. Example usage:$exampleUsage"
    exit 1
fi

if [ "$ccmbVersion1" = "$ccmbVersion2" ]
then
    echo "ccmb1 and ccmb2 can't be the same versions"
    exit 1
fi

if [[ ! -d "$ccmb1Path" || ! -d "$ccmb2Path" ]]
then
    echo "$ccmb1Path and $ccmb2Path has to exist on a system"
    exit 1
fi

if    ls -1qA $updatePath/CCMB/ | grep -q .
then
    echo "$updatePath/CCMB/ is not empty. Please move/backup CCMB version from there and restore it after you'll end up using this script"
    exit 1
fi

echo -e "\n\n\nStarting installation loop\n\n\n"
for (( i = 0 ; i < $installationsCount ; ++i))
do
    echo -e "\n\n\nInstallation number $i. $ccmb1Path\n\n\n"
    mv $ccmb1Path $candidatePath
    /opt/LanTEK/scripts/ccmb/install-update.sh
    mv $candidatePath/* $updatePath
    result=$?
    if [ $result != 0 ]
    then
        echo -e "\n\n\nCCMB installation failed for $i time. CCMB: $ccmbVersion1\n\n\n"
        exit 1
    fi


    echo -e "\n\n\nInstallation number $i. $ccmb2Path\n\n\n"
    mv $ccmb2Path $candidatePath
    /opt/LanTEK//scripts/ccmb/install-update.sh
    mv $candidatePath/* $updatePath
    result=$?
    if [ $result != 0 ]
    then
    echo -e "\n\n\nCCMB installation failed for $i time. CCMB: $ccmbVersion2\n\n\n"
        exit 1
    fi
done

echo -e "\n\n\nSuccesfully completed $installationsCount installation sequences\n\n\n"

exit 0

